/**
 * \file: SignalHandler.c
 *
 * \version: $Id:$
 *
 * \release: $Name:$
 *
 * <brief description>.
 * <detailed description>
 * \component: CarPlay
 *
 * \author:  Tousif M T /RBEI/ECF3/ tousif.mt@in.bosch.com
 *
 * \copyright (c) 2013-2014 Advanced Driver Information Technology.
 * This code is developed by Advanced Driver Information Technology.
 * Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
 * All rights reserved.
 *
 * \see <related items>
 *
 * \history
 *
 ***********************************************************************/

#include <execinfo.h>
#include <stdio.h>
#include <sys/signalfd.h>
#include <signal.h>

#include "ThreadUtils.h"
#include "Common.h"
#include "utils/Statistics.h"

namespace adit { namespace carplay {

static void HandleSigterm();

void HandleSigterm(void)
{
    CFRunLoopStop( CFRunLoopGetMain() );

    return;
}


void
    SignalHandlerCallBack(
        CFFileDescriptorRef inDesc,
        CFOptionFlags       inCallBackTypes,
        void *              inContext )
{
    inDesc = inDesc;
    inCallBackTypes = inCallBackTypes;
    inContext = inContext;
    struct signalfd_siginfo fdsi;
    ssize_t s;

    int sfd = CFFileDescriptorGetNativeDescriptor( inDesc );

    s = read(sfd, &fdsi, sizeof(struct signalfd_siginfo));

    if (s != sizeof(struct signalfd_siginfo))
    {
        printf("could not read signalfd\n");
        return;
    }

    fprintf(stdout, "CarPlay: Signal Received (%d)\n", fdsi.ssi_signo);
    fflush(stdout);

    switch (fdsi.ssi_signo)
    {
    case SIGTERM:
        HandleSigterm();
        break;
    case SIGUSR1:
        adit::carplay::Statistics::Instance().DumpStatistics();
        break;
    default:
        fprintf(stderr, "CarPlay: Signal not handled!\n");
        break;
    }

    fflush(stdout);
}



void RegisterSignalHandler(void)
{
    CFFileDescriptorContext     fileDescContext;
    CFFileDescriptorRef         fileDesc;
    int sfd;
    sigset_t mask;
    CFRunLoopRef rl = CFRunLoopGetCurrent();
    CFRunLoopSourceRef source;

    sigemptyset(&mask);
    sigaddset(&mask, SIGTERM);
    sigaddset(&mask, SIGUSR1);

    if (sigprocmask(SIG_BLOCK, &mask, NULL) == -1)
    {
        fprintf(stderr, "could not set procmask\n");
        fflush(stderr);
        return;
    }

    sfd = signalfd(-1, &mask, 0);
    memset( &fileDescContext, 0, sizeof( fileDescContext ) );

    fileDesc = CFFileDescriptorCreate( kCFAllocatorDefault, sfd, true, SignalHandlerCallBack,
        &fileDescContext );
    if(!fileDesc)
    {
        fprintf(stderr, "could not create fileDesc\n");
        fflush(stderr);
        return;
    }


    CFFileDescriptorEnableCallBacks( fileDesc, kCFFileDescriptorReadCallBack );

    source = CFFileDescriptorCreateRunLoopSource( kCFAllocatorDefault, fileDesc, 0 );
    if(!source)
    {
        fprintf(stderr, "could not create RunLoopSource\n");
        fflush(stderr);
        return;
    }

    CFRunLoopAddSource( rl, source, kCFRunLoopCommonModes );
    CFRelease( source );
}

} } // namespace adit { namespace carplay
